<?xml version="1.0" encoding="UTF-8"?>
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" abstract="true" id="MFMT_MT902001NL">
    <title>ActReference Activate/Revise</title>
    <rule context="$element">
        <!--assert role="error" test="not(@classCode) or @classCode='CATEGORY'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/ActClass.htm#CATEGORY"
            >MFMT_MT902001NL: <value-of select="local-name(.)"/>/@classCode moet 'CATEGORY' zijn</assert>
        <assert role="error" test="not(@moodCode) or @moodCode='EVN'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/ActMood.htm#EVN"
            >MFMT_MT902001NL: <value-of select="local-name(.)"/>/@moodCode moet 'EVN' zijn</assert-->
        
        <let name="codeValue" value="../../hl7:code/@code"/>
        <let name="codeSystem" value="../../hl7:code/@codeSystem"/>
        
        <let name="classCode" value="@classCode"/>
        <let name="classCodeRoot" value="'2.16.840.1.113883.5.6'"/>
        <let name="expectClassCode" value="document(concat('../vocab/',$codeSystem,'.xml'))/*/hl7:code[@code=$codeValue]/hl7:reference[@root=$classCodeRoot]/@extension"/>
        
        <!-- Niet alle ActRegistryCodes hebben reeds een reference element -->
        <assert role="error" test="@classCode"
            >MFMT_MT902001NL: @classCode is verplicht</assert>
        <assert role="error" test="$classCode='CATEGORY' or 
            not(document(concat('../vocab/',$codeSystem,'.xml'))/*/hl7:code[@code=$codeValue]/hl7:reference) or
            $classCode=$expectClassCode"
            >MFMT_MT902001NL: Gegevenssoort '<value-of select="$codeValue"/>' komt niet overeen met de classCode van de ActReference '<value-of select="@classCode"/>'. Verwacht werd '<value-of select="$expectClassCode"/>'.</assert>
        
        <let name="moodCode" value="@moodCode"/>
        <let name="moodCodeRoot" value="'2.16.840.1.113883.5.1001'"/>
        <let name="expectMoodCode" value="document(concat('../vocab/',$codeSystem,'.xml'))/*/hl7:code[@code=$codeValue]/hl7:reference[@root=$moodCodeRoot]/@extension"/>
        
        <assert role="error" test="not($classCode='CATEGORY') or $moodCode='EVN'"
            >MFMT_MT902001NL: @moodCode moet 'EVN' zijn voor categorale aanmeldingen</assert>
        
        <assert role="error" test="$classCode='CATEGORY' or 
            not(document(concat('../vocab/',$codeSystem,'.xml'))/*/hl7:code[@code=$codeValue]/hl7:reference) or
            $moodCode=$expectMoodCode"
            >MFMT_MT902001NL: Gegevenssoort '<value-of select="$codeValue"/>' komt niet overeen met de moodCode van de ActReference '<value-of select="@moodCode"/>'. Verwacht werd '<value-of select="$expectMoodCode"/>'.</assert>
    </rule>
    
    <title>ActReference/id</title>
    <rule context="$element/hl7:id">
        <extends rule="II"/>
        <assert role="error" test="not(@nullFlavor)"
            >MFMT_MT902001NL: id moet een waarde bevatten</assert>
    </rule>
    
    <title>ActReference/effectiveTime</title>
    <rule context="$element/hl7:effectiveTime">
        <extends rule="IVL_TS"/>
        <assert role="error" test="(@value and not(*)) or ((hl7:low/@value or hl7:high/@value) and not(@value) and not(hl7:width or hl7:center))"
            >MFMT_MT902001NL: alleen effectiveTime/@value (exact datum/tijdstip), of een effectiveTime/low (begin periode) en/of effectiveTime/high (einde periode) zijn toegestaan</assert>
        <assert role="warning" test="not(../hl7:statusCode/@code='active' and hl7:high)"
            >MFMT_MT902001NL: element effectiveTime/high (einde geldigheidsperiode) kan geen waarde hebben indien statusCode='active' (actuele status geldigheid), tenzij het een waarde in de toekomst betreft</assert>
    </rule>
    
    <title>ActReference/recordTarget</title>
    <rule context="$element/hl7:recordTarget/hl7:patient">
        <assert role="warning" test="count(hl7:id)=1"
            >MFMT_MT902001NL: alleen het burgerservicenummer van de patiënt wordt opgeslagen</assert>
    </rule>
    
    <rule context="$element/hl7:recordTarget/hl7:patient/hl7:id">
        <extends rule="II"/>
        <assert role="error" test="@root='2.16.840.1.113883.2.4.6.3'"
            >MFMT_MT902001NL: patient/id moet een burgerservicenummer zijn</assert>
    </rule>

    <title>ActReference/subjectOf</title>
    <rule context="$element/hl7:subjectOf/hl7:controlActEvent/hl7:effectiveTime">
        <extends rule="TS"/>
        <assert role="error" test="@value"
            >MFMT_MT902001NL: subjectOf/controlActEvent/effectiveTime/@value is verplicht</assert>
        <assert role="error" test="substring(concat(string(@value),'00000000000000'),1,14) &lt;= 
            substring(concat(string(../../../../../../../../hl7:creationTime/@value),'00000000000000'),1,14)"
            >MFMT_MT902001NL: subjectOf/controlActEvent/effectiveTime/@value (laatste wijzigingsdatum) kan niet nieuwer zijn dan de aanmaakdatum van de interactie</assert>
    </rule>
 </pattern>
